<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PageContent;
use Illuminate\Http\Request;

class ContentController extends Controller
{
    public function index(Request $request)
    {
        $query = PageContent::orderBy('section')->orderBy('page_key');
        
        if ($request->has('section') && $request->section) {
            $query->where('section', $request->section);
        }
        
        $contents = $query->get();
        $sections = PageContent::select('section')->distinct()->whereNotNull('section')->pluck('section');
        
        return view('admin.contents.index', compact('contents', 'sections'));
    }

    public function create()
    {
        return view('admin.contents.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'page_key' => 'required|string|max:255|unique:page_contents,page_key',
            'section' => 'nullable|string|max:255',
            'label' => 'required|string|max:255',
            'content' => 'nullable|string',
            'type' => 'required|string|in:text,html,image',
        ]);

        PageContent::create($validated);

        return redirect()->route('admin.contents.index')
            ->with('success', 'Content created successfully!');
    }

    public function show(PageContent $content)
    {
        return view('admin.contents.show', compact('content'));
    }

    public function edit(PageContent $content)
    {
        return view('admin.contents.edit', compact('content'));
    }

    public function update(Request $request, PageContent $content)
    {
        $validated = $request->validate([
            'page_key' => 'required|string|max:255|unique:page_contents,page_key,' . $content->id,
            'section' => 'nullable|string|max:255',
            'label' => 'required|string|max:255',
            'content' => 'nullable|string',
            'type' => 'required|string|in:text,html,image',
        ]);

        $content->update($validated);

        return redirect()->route('admin.contents.index')
            ->with('success', 'Content updated successfully!');
    }

    public function destroy(PageContent $content)
    {
        $content->delete();

        return redirect()->route('admin.contents.index')
            ->with('success', 'Content deleted successfully!');
    }
}
